/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.activityfolder;

import com.quantumdata.sct.dao.impl.DeviceModelDAO;
import com.quantumdata.sct.dao.impl.ModelCapabilityDAO;
import com.quantumdata.sct.dao.impl.ModelDAO;
import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.vo.DeviceModelVO;
import com.quantumdata.sct.dao.vo.ModelCapabilityVO;
import com.quantumdata.sct.dao.vo.ModelVO;
import com.quantumdata.sct.gui.common.MessageOptionPane;
import com.quantumdata.sct.gui.common.SCTButton;
import com.quantumdata.sct.gui.common.SCTConstants;
import com.quantumdata.sct.gui.common.SCTLabel;
import com.quantumdata.sct.gui.common.SCTPanel;
import com.quantumdata.sct.gui.common.SCTTextField;
import com.quantumdata.sct.util.SCTSelection;
import com.quantumdata.sct.util.keygen.KeyGeneratorFactory;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class CreateNewModel
extends JDialog
implements ActionListener {
    private SCTTextField modelnumberTextField;
    private SCTTextField modelnameTextField;
    private SCTTextField mftnameTextField;
    private SCTTextField descTextField;
    private SCTTextField partNumTF;
    private SCTTextField upcTF;
    private SCTButton saveButton;
    private SCTButton cancelButton;
    private boolean isSaveBtnPressed = false;
    private ModelVO srcModelVO;

    public CreateNewModel(JDialog jDialog, ModelVO modelVO) {
        super((Dialog)jDialog, true);
        this.srcModelVO = modelVO;
        this.init();
    }

    public CreateNewModel(JFrame jFrame, ModelVO modelVO) {
        super((Frame)jFrame, true);
        this.srcModelVO = modelVO;
        this.init();
    }

    private void init() {
        Container container = this.getContentPane();
        this.setTitle("Add New CDF");
        container.add(this.newModelPanel());
        this.pack();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                CreateNewModel.this.pack();
            }
        });
        SCTConstants.screenCenterPlacement(this);
    }

    private SCTPanel newModelPanel() {
        SCTPanel sCTPanel = new SCTPanel();
        BoxLayout boxLayout = new BoxLayout(sCTPanel, 1);
        sCTPanel.setLayout(boxLayout);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        SCTPanel sCTPanel2 = new SCTPanel(gridBagLayout);
        SCTLabel sCTLabel = new SCTLabel("Model Number");
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(sCTLabel, gridBagConstraints);
        sCTPanel2.add(sCTLabel);
        this.modelnumberTextField = new SCTTextField(20);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.modelnumberTextField, gridBagConstraints);
        sCTPanel2.add(this.modelnumberTextField);
        SCTLabel sCTLabel2 = new SCTLabel("Model Name");
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(sCTLabel2, gridBagConstraints);
        sCTPanel2.add(sCTLabel2);
        this.modelnameTextField = new SCTTextField(20);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.modelnameTextField, gridBagConstraints);
        sCTPanel2.add(this.modelnameTextField);
        SCTLabel sCTLabel3 = new SCTLabel("Part Number");
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(sCTLabel3, gridBagConstraints);
        sCTPanel2.add(sCTLabel3);
        this.partNumTF = new SCTTextField(20);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.partNumTF, gridBagConstraints);
        sCTPanel2.add(this.partNumTF);
        SCTLabel sCTLabel4 = new SCTLabel("UPC");
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(sCTLabel4, gridBagConstraints);
        sCTPanel2.add(sCTLabel4);
        this.upcTF = new SCTTextField(20);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.upcTF, gridBagConstraints);
        sCTPanel2.add(this.upcTF);
        SCTLabel sCTLabel5 = new SCTLabel("CDF Description");
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(sCTLabel5, gridBagConstraints);
        sCTPanel2.add(sCTLabel5);
        this.descTextField = new SCTTextField(20);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.descTextField, gridBagConstraints);
        sCTPanel2.add(this.descTextField);
        SCTLabel sCTLabel6 = new SCTLabel("Manufacturer Name");
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(sCTLabel6, gridBagConstraints);
        sCTPanel2.add(sCTLabel6);
        this.mftnameTextField = new SCTTextField(20);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.mftnameTextField, gridBagConstraints);
        sCTPanel2.add(this.mftnameTextField);
        SCTPanel sCTPanel3 = new SCTPanel(new FlowLayout(1, 20, 0));
        this.saveButton = new SCTButton("Save Model");
        this.saveButton.addActionListener(this);
        sCTPanel3.add(this.saveButton);
        this.cancelButton = new SCTButton("Cancel");
        this.cancelButton.addActionListener(this);
        sCTPanel3.add(this.cancelButton);
        sCTPanel.add(sCTPanel2);
        sCTPanel.add(sCTPanel3);
        return sCTPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.saveButton) {
            this.saveNewModel();
            this.isSaveBtnPressed = true;
            this.dispose();
        }
        if (actionEvent.getSource() == this.cancelButton) {
            this.dispose();
        }
    }

    public boolean isSaveBtnPressed() {
        return this.isSaveBtnPressed;
    }

    private ModelVO addModel() throws Exception {
        ModelVO modelVO = new ModelVO();
        modelVO.setId(KeyGeneratorFactory.getModelKG().generateUniqueKey());
        modelVO.setNew(true);
        modelVO.setNumber(this.modelnumberTextField.getText());
        modelVO.setName(this.modelnameTextField.getText());
        modelVO.setDescription(this.descTextField.getText());
        modelVO.setManufacturer(this.mftnameTextField.getText());
        modelVO.setPartNumber(this.partNumTF.getText());
        modelVO.setUpc(this.upcTF.getText());
        modelVO.setUpdateable(true);
        modelVO.setDeletable(true);
        ModelDAO modelDAO = (ModelDAO)XMLDAOFactory.getModelDAO();
        modelDAO.add(modelVO);
        return modelVO;
    }

    private void updateDeviceModel(ModelVO modelVO) throws Exception {
        DeviceModelDAO deviceModelDAO = (DeviceModelDAO)XMLDAOFactory.getDeviceModelDAO();
        IPersistable[] iPersistableArray = deviceModelDAO.readAll();
        for (int i = 0; i < iPersistableArray.length; ++i) {
            DeviceModelVO deviceModelVO = (DeviceModelVO)iPersistableArray[i];
            if (!deviceModelVO.getModels().contains(this.srcModelVO.getId())) continue;
            deviceModelVO.add(modelVO.getId().toString());
            deviceModelDAO.update(deviceModelVO);
        }
    }

    private void copyModelCapabilities(ModelVO modelVO) {
        try {
            ModelCapabilityDAO modelCapabilityDAO = (ModelCapabilityDAO)XMLDAOFactory.getModelCapabilityDAO();
            ModelCapabilityVO modelCapabilityVO = (ModelCapabilityVO)modelCapabilityDAO.read(this.srcModelVO.getId());
            ModelCapabilityVO modelCapabilityVO2 = new ModelCapabilityVO();
            modelCapabilityVO2.setModelId(modelVO.getId().toString());
            modelCapabilityVO2.setCapabilities(modelCapabilityVO.getCapabilities());
            modelCapabilityDAO.add(modelCapabilityVO2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveNewModel() {
        MessageOptionPane messageOptionPane = new MessageOptionPane();
        try {
            ModelVO modelVO = this.addModel();
            this.updateDeviceModel(modelVO);
            this.copyModelCapabilities(modelVO);
            SCTSelection.instance().setModelID((String)modelVO.getId(), false);
            MessageOptionPane.ShowMessage(this, "Successfully added new CDF.", "Add");
        }
        catch (Exception exception) {
            MessageOptionPane.ShowErrorMessage(this, "CDF could not be added", "Add");
            exception.printStackTrace();
        }
    }
}

